# Setup settings

## Powertrain
Adjust fuel level.

Adjust gearing and engine settings to get most out of the torque and horsepower on a given track.

Electronic aids (anti-lock brakes, traction control) reduce mistakes under braking and acceleration. In the case of an experienced driver, they usually don't help significantly with lap time.

The differential (power, coast and preload) settings have a significant effect on car handling mostly during the corner entry and exit phases.

### Engine & electronics
This section lets you adjust a few settings related to the power your car's engine provides. Note that the settings you can select are specific for each car, so the effect they produce will be different for different cars.

#### Starting fuel
The amount of fuel you fill the car with before you start driving. The amount is usually given in liters or gallons. For some cars the amount may be given in kilograms. The number between brackets is the estimated number of laps you can drive with this amount of fuel.

Note: some tracks may not provide you with an estimate, this will show as “(N/A)” after the fuel amount. Also, you should be aware that the number of laps is an estimate only. There are many variables that influence the actual distance you will manage to drive, such as your driving style, driver errors and weather and road conditions.

#### Rev limiter
The maximum revs your engine can reach.

#### Engine mixture
Lets you choose different fuel maps for your engine to influence the engine's power and fuel efficiency.

#### Boost mapping
Lets you choose different boost profiles for engines with adjustable turbo compression.

#### Brake map
Lets you choose different profiles for the strength with which the engine slows the car when the throttle is released.

#### Radiator size
Affects the cooling of the engine as well as the amount of drag your car experiences.

### Electronics

#### Onboard TC
The level of assistance provided by the TC systems for cars that have such systems installed. It can also be adjusted dynamically when driving.
For newer cars, which have an updated TC system this option controls the longitudinal slip (similar to wheel spin).
#### Onboard TC power cut
The amount of power that is cut when TC activates. Only available for the updated TC system. This option may be linked to the "Onboard TC" so that this option cannot be controlled individually. This level can also be adjusted dynamically when driving when available.
#### Onboard TC slip angle
Controls how much slip angle (lateral side-slip) is allowed before the TC activates. Only available for the updated TC system. This option may be linked to the "Onboard TC" so that this option cannot be controlled individually. This level can also be adjusted dynamically when driving when available.
#### Onboard ABS
The level of assistance provided by the ABS systems for cars that have such systems installed. It can also be adjusted dynamically when driving.

#### Regen level
Lets you choose different regeneration profiles for electric motors with adjustable regeneration levels.

#### Electric motor map
Lets you choose different motor profiles for electric motors with adjustable power levels.

#### Push 2 Pass map
Lets you choose different push-to-pass profiles for vehicles with adjustable boost levels.

### Gearing

#### 1st gear
#### 2nd gear
#### 3rd gear
#### 4th gear
#### 5th gear
#### 6th gear
#### 7th gear
#### 8th gear
#### 9th gear
These selectors show the gear ratios for each gear. For cars that allow you to adjust gear ratios, these selectors let you increase or decrease the ratios for each gear. When you do so, the graph will show you how that affects your shift points relative to speed and engine revs.
Each gear ratio selector shows two values (when available). The first value is the ratio for that particular gear by itself. The second value (between brackets) is the final gear ratio, which takes into account the differential of your car. Since the differential typically has a value higher than 1, you will see that the final ratio is a multiple of the gear ratio for each gear. You can find the final gear ratio at the bottom of the "Gears" list of selectors.

#### Final
Lets you (for cars that have this feature) change the differential of your car, which affects the ratio of your gears by applying this final ratio to the ratio of each individual gear.

#### Reverse
Lets you change the ratio of the reverse gear, for the (relatively few) cars that allow this.

### Automatic gearbox
This section lets you turn autoshift on and off for upshifting and/or downshifting automatically in the few cars that support this.

#### Auto upshift
Turns auto upshift on or off.

#### Auto downshift
Turns auto downshift on or off.

### Differential

#### Pump
For cars with differentials of a 'limited slip' type, such as F1 cars - this selector lets you determine what percentage of the maximum available torque is shifted to the wheel that has the least amount of traction. The actual torque received by each wheel is a function of this percentage, the difference in spin speed between the wheels, and the maximum available torque for your car.

#### Power
The amount of torque that is shifted to the outside wheel when taking a corner and accelerating.

#### Coast
The amount of torque that is shifted to the internal wheel when taking a corner and lifting the throttle.

#### Preload
The amount of torque required before the differential starts shifting torque to one side.

#### Torque split
The distribution of torque between front and rear wheels in 4WD cars.

## Strategy
Adjust your pit strategy.

### Pitstops

#### Number of stops
#### Stop 1
#### Stop 2
#### Stop 3
These settings are used to determine you pit stop refuelling strategy. The "Number of stops" allows you to enter up to 3 planned pit stops. Then for each planned stop you can determine how much fuel will be added to your car.

## Wheels & brakes
Tire compound affects overall grip levels and wear.

Adjust pressure and camber to get the most grip out of the tires on qualifying runs, and the best durability on longer stints.

Ensuring that your braking system shares the load proportionately will create a fast and stable car on corner entry. Brake bias can usually also be adjusted in-car for optimal braking in different types of corners.

### Wheels

#### Symmetrical
You can turn symmetry on and off by clicking on the link symbol. When the icon is that of a broken link you can set different values for the left and right side of the car. When the icon is that of a unbroken link, any value you change (either left or right) will also be applied to the other side.

Note than when you have set different values for left and right with symmetry turned off, those different values will remain when you turn symmetry back on. The moment you change one of the values, however, that change will apply to both sides.

#### Compound
A choice of different tire compounds, when available. 
Choosing then right tires for the weather and track conditions is important. Rain tires, for instance, are very temperature sensitive and designed to be operate within a very limited range of conditions only. The options available and the names they are given are determined by the make and model of your car and not all compounds will be available for all tracks you race on.

#### Tyre pressure
The 'cold' pressure in your tires - when the car is stationary and hasn't driven yet.

The display to the right will show you the actual tire pressures measured just before you re-entered the garage after driving your car on the track. Some cars use tire-heaters to pre-warm the tires before driving the car. When they do, you will see that your tire pressures before driving are already higher than the cold pressures you put in. This snapshot shown on the right is there to help you check how your tires behaved during your time on the track and adjust the cold settings accordingly. You can, of course, also check your tire temperature and pressure while driving. Should you have forgotten to do, however, you can come back to the garage and see the last measurements here.

Note that the tire pressures return to 'cold' conditions after you return to the garage.

#### Camber
The angle with which a wheel leans either towards or away from the chassis. A negative value means the upper part of the tire is closer to the chassis that the bottom part. A positive value means the upper part of the tire is further away from the chassis than the bottom part. A positive value is generally used only for stock cars on oval tracks and then only for the wheels on the left-hand side of the car.

#### Brake disc
The thickness of the brake discs installed in your car's brakes.

The main reason to adjust the brake disc thickness is to compensate for excessive heating up of your brakes when driving. Thicker brake discs have more mass and therefore absorb more heat, which reduces the tendency to overheat. The most frequent use for these adjustments is to allow for different braking needs between short races (thinner discs) and endurance races (thicker discs).

### Brakes

#### Brake bias
The distribution of the braking power between the front and rear wheels when braking. These values can also be changed dynamically while you are driving.

#### Max pedal force
The maximum effort you can apply to press down the brake pedal. The first value is the actual force applied, the value between brackets shows the selected value as a percentage of the maximum possible force available in your car.

This value is used for rigs with brakes equipped with load cells to give you the possibility to get a realistic feeling behaviour from your brake pedals.

#### Front brake duct blanking
#### Rear brake duct blanking
The amount of brake cooling applied to the brakes. The value relates to the diameter of the cooling duct which affects the amount of air flowing through the duct over the brakes.

This setting is typically used to ensure the brakes are cooled just enough to prevent overheating but not so much they are prevented from reaching their optimal braking temperature.

#### Handbrake pressure
The maximum force applied by your car's handbrake, for cars that support this feature.

## Suspension
Springs and anti-roll bars are some of the most important adjustments you can make to affect the handling of the car. With high downforce cars these settings (along with ride height and packers) are also crucial for keeping the chassis at the correct height for maximum downforce through fast corners.

### Suspension

#### Spring rate
Affects the spring stiffness of the suspension.
Some cars allow the adjustment of a third element, which only relates to the car's up and down movements relative to the road. This is mostly used for cars that have to deal with a high downforce at high speeds. Adjusting these values determines how much the body is compressed by the downforce exerted on the car on straight stretches.

#### Tender spring rate
Affects the stiffness (and length) of the tender springs.
A tender spring is a softer spring sitting on top of the main spring. It is only active to a certain point in suspension travel after which only the main spring remains active. It makes the suspension relatively soft within initial compression and allows the tyre to stay in contact with the ground and better absorb lumps and bumps.
In case the tender spring has a relatively low spring rate (10-20 N/mm) its usage is to keep the main spring in place if it is not long enough to cover the full stroke of the damper when uncompressed. In this case, the tender spring usually already fully compresses under the static load of the car.

#### Packers
The thickness of the packers: stiff elements, similar to washers, that limit the distance the suspension can compress. Typically, packers are used to prevent the underside of the car from hitting the road when pushed downwards.

#### Ride height
The ground clearance for each corner of your car. The values you set are the distances from the ground before the car is fuelled up. Adding fuel will increase the car's weight, which compresses the suspension and reduces the actual ride height of the car.

#### Spring rubber
The presence and action of spring rubbers, which are similar to packers but softer, so they add a 'cushion' effect to the way they limit spring compression. Spring rubbers are not often used.


### Front suspension

#### Anti-roll bar
The stiffness of the anti-roll bar connecting the left and right wheel. Higher values mean stronger limitation of independent movements of the wheels in relation to each other when taking corners.

#### Toe-in
The steering response of the wheels when entering a corner.

#### Toe-in offset
The toe offset of the wheels. This allows you to give the wheels an offset to the left or right when you steering wheel is in neutral position, i.e. when the car is supposed to drive in a straight line. This can be used, for instance, for racing on ovals, to compensate for the centrifugal force pushing the car sideways at higher speeds.

### Aerodynamics

#### Front wing
The angle of the front wing, affecting the downforce and drag your car experiences.
#### Rear wing
The angle of the rear wing, affecting the downforce and drag your car experiences.

## Dampers
Dampers (slow/fast bump/rebound) can be used to fine-tune the handling in corner entries and exits, and also when driving over kerbs and bumps.

### Front dampers
### Rear dampers

#### Slow bump
#### Slow rebound
#### Fast bump
#### Fast rebound
The stiffness of your car's dampers that slow down the suspension's spring movements. Typically, the higher the number, the more the damper will resist the spring's movement and slow it down.

The 'Slow' settings affect body movement of your car (up, down, sideways and roll) in moments of weight transfer, such as when braking, accelerating and entering corners. These settings affect the balance of your car.

The 'Fast' settings affect wheel movement when driving over bumps and irregularities on the road. These settings affect the way your car behaves when driving on rough surfaces.

The 'Bump' settings affect how much the damper slows down the suspension's spring *compression*.

The 'rebound' settings slow down the suspension's spring *expansion*.

## Chassis & aero
Adjust the balance of the car with weight distribution and the feel of the steering with caster and wheel range.

Adjusting the front and rear wing of the car will alter the handling mostly in high-speed corners and will also affect straight line speed.

### Chassis

#### Flip ups
Lets you place one or more flip ups (also called fender flares) on the wings of your car to slightly alter your car's aerodynamics.

#### Track bar
Primarily used in stock cars, track bar controls the left-to-right offset of the rear axle. Increasing this setting on both sides will make the car oversteer more. On ovals, increasing the left side will make the car oversteer more in turn entry, and increasing the right side will make the car oversteer more in turn exit.

#### Caster
The caster angle. This affects the wheel alignment by changing the angle of the suspension when taking corners. You can use this to adjust the force feedback you experience while driving.

Note that changing the caster settings also affects the dynamic camber of your car.

#### Front wheel track
#### Rear wheel track
The track width of your front wheels (how far apart they are) and your rear wheels, respectively.

Note that in rFactor 2, the track width is measured as the distance between the centres (in 3 dimensions) of both wheels. This is slightly different from how track widths are usually measured, which is as the distance between the two contact points of each tire with the ground. There can be a small difference between these two ways of measuring track width depending on your camber settings (see "Tires").

#### Steering lock
Changes the responsiveness of your steering wheel, or 'steering ratio', by changing the number of teeth in the steering pinion.

### Weight

#### Vertical
The vertical distance between the car's centre of gravity and the ground. For the few cars where this *is* adjustable you can change that value here.
 
#### Lateral
The lateral weight distribution by shifting the car's centre of gravity more to the left or the right of the car. In almost all cases, the lateral distribution is 50/50 (i.e. exactly in the middle between left and right), or very close to that.

The lateral distribution may also be changed when applying weight penalties - for instance in electrical cars. Such weight penalties are applied by placing metal plates in the car and it's up to the team to decide where to place those plates to provide optimal performance. 

#### Weight distribution
The weight distribution of your car by shifting the car's centre of gravity more to the front or back of the car. This distribution is usually regulated and not allowed to be changed.

#### Wedge
Used primarily in stock cars and IndyCar (known as weight jacker) on ovals. This affects the cross-weight in the car. Decreasing this setting will make the car oversteer more on ovals (left-hand turns).

### Advanced Chassis

#### Chassis adjustment 1
#### Chassis adjustment 2
#### Chassis adjustment 3
#### Chassis adjustment 4
#### Chassis adjustment 5
#### Chassis adjustment 6
#### Chassis adjustment 7
#### Chassis adjustment 8
#### Chassis adjustment 9
#### Chassis adjustment 10
#### Chassis adjustment 11
#### Chassis adjustment 12
These selectors relate to additional features of certain cars not covered by the standard settings available. Which of these can be changed and what effect they have depends entirely on the make and model of your car.